#include <iostream>
#include <windows.h>
#include <Mmsystem.h>
#include <mmreg.h>
#include "types.h"

using namespace std;

static void exitError( MMRESULT res, const char* file, const int line )
{
	char err[ 256 ];
	waveOutGetErrorText( res, err, 256 );
	cerr << file << ":" << line << ": " << err << endl;
	exit( 1 );
}

#define CHECKERROR(res) \
if( res != MMSYSERR_NOERROR  ) { \
		exitError( res, __FILE__, __LINE__ );\
	}


void enumerateWaveout()
{
	UINT devices = waveOutGetNumDevs();
	WAVEOUTCAPS caps;
	for( UINT i = 0; i < devices; i++ ) {
		waveOutGetDevCaps( i, &caps, sizeof(WAVEOUTCAPS) );
		cout << i << ": " << caps.szPname << endl;
	}
}

void playWave( int sampleFreq, const u8* data, int sampleAmount, int device )
{
	WAVEFORMATEX mm_format;

 	mm_format.wFormatTag = WAVE_FORMAT_PCM;
	mm_format.wBitsPerSample = 8;
	mm_format.nChannels = 1;
 	mm_format.nSamplesPerSec = sampleFreq;
	mm_format.nBlockAlign = mm_format.nChannels * mm_format.wBitsPerSample / 8;
	mm_format.nAvgBytesPerSec = mm_format.nBlockAlign * mm_format.nSamplesPerSec;
	mm_format.cbSize = 0;

	HWAVEOUT h;
	
	MMRESULT res = waveOutOpen( &h, device >= 0 ? device : WAVE_MAPPER, &mm_format, 0, 0, CALLBACK_NULL );
	CHECKERROR( res );

	WAVEHDR hdr;

	hdr.lpData = (char*)data;
	hdr.dwBufferLength = sampleAmount;
	hdr.dwFlags = 0;

	res = waveOutPrepareHeader( h, &hdr, sizeof( WAVEHDR ) );
	CHECKERROR( res );

	res = waveOutWrite( h, &hdr, sizeof( WAVEHDR ) );
	CHECKERROR( res );

	while( !( hdr.dwFlags & WHDR_DONE ) ) {
		MMTIME mt;
		mt.wType = TIME_SAMPLES;
		waveOutGetPosition( h, &mt, sizeof( mt ) );

		int done = mt.u.sample * 100 / sampleAmount;

		cout << "\r" << "Playback: " << done << "%";

		Sleep( 50 );
	}
	cout << "\r                                ";

	waveOutUnprepareHeader( h, &hdr, sizeof( WAVEHDR ) );
	waveOutClose( h );

}